/*******************************************************************************
+
+	generic_cluster.cc
+
+   Copyright (C) 2000
+	Kevin Pulo, kev@hons.cs.usyd.edu.au.
+	Garrick Welsh, gaz@hons.cs.usyd.edu.au.
+
+	This program is free software; you can redistribute it and/or modify
+	it under the terms of the GNU General Public License as published by
+	the Free Software Foundation; either version 2 of the License, or
+	(at your option) any later version.
+
+	This program is distributed in the hope that it will be useful,
+	but WITHOUT ANY WARRANTY; without even the implied warranty of
+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+	GNU General Public License for more details.
+
+	You should have received a copy of the GNU General Public License
+	along with this program; if not, write to the Free Software
+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
+
*******************************************************************************/

#include "cluster.hh"

Cluster::Cluster(void)
{
	ID = 0;

}

Cluster::Cluster(int id)
{
	ID = id;
}

point Cluster::meanPoint(void)
{
	// pre: points.length() > 0
	point p;

	double x = 0.0;
	double y = 0.0;
	forall(p, points) {
		x += p.xcoord();
		y += p.ycoord();
	}
	return point(x/(double)points.length(), y/(double)points.length());
}

list<point> &Cluster::getList(void)
{
	return points;
}

list_item Cluster::append(const point &p)
{
	return points.append(p);
}


istream &operator>>(istream &is, Cluster &clus)
{
	return is;	
}

ostream &operator<<(ostream &os, const Cluster &clus)
{
	return os;	
}
