/*******************************************************************************
+
+	algorithms.cc
+
+   Copyright (C) 2000
+	Kevin Pulo, kev@hons.cs.usyd.edu.au.
+	Garrick Welsh, gaz@hons.cs.usyd.edu.au.
+
+	This program is free software; you can redistribute it and/or modify
+	it under the terms of the GNU General Public License as published by
+	the Free Software Foundation; either version 2 of the License, or
+	(at your option) any later version.
+
+	This program is distributed in the hope that it will be useful,
+	but WITHOUT ANY WARRANTY; without even the implied warranty of
+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+	GNU General Public License for more details.
+
+	You should have received a copy of the GNU General Public License
+	along with this program; if not, write to the Free Software
+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
+
+	$Id: algorithms.cc,v 1.5 2000/05/28 08:15:40 kev Exp $
+
*******************************************************************************/

#include "algorithms.hh"
#include "cluster_test.hh"
#include "cluster_random.hh"
#include "cluster_kmeans.hh"
#include "cluster_tb.hh"
#include "cluster_ech.hh"


static const char *rcsid = "$Id: algorithms.cc,v 1.5 2000/05/28 08:15:40 kev Exp $";
static const char *rcsrevision = "$Revision: 1.5 $";


static dictionary<string, void (*)(int)> algorithms;


void registerAlgorithms() {
	algorithms.insert("", cluster_kmeans);

	algorithms.insert("test_ascending", cluster_test_ascending);
	algorithms.insert("ascending", cluster_test_ascending);

	algorithms.insert("test_single", cluster_test_single);
	algorithms.insert("single", cluster_test_single);

	algorithms.insert("test_cheat", cluster_test_cheat);
	algorithms.insert("cheat", cluster_test_cheat);

	algorithms.insert("random", cluster_random);
	algorithms.insert("rand", cluster_random);

	algorithms.insert("kmeans", cluster_kmeans);

	algorithms.insert("tb", cluster_tb);

	algorithms.insert("ech", cluster_ech);
}

void runAlgorithm(string algorithm, int k) {
	if (algorithms.lookup(algorithm)) {
		(*debug) << "Using algorithm: '" << algorithm << "'" << endl;
		(*algorithms.access(algorithm))(k);
	} else {
		cerr << "WARNING: Unknown algorithm: '" << algorithm << "'" << endl;
		if (algorithms.lookup("")) {
			(*debug) << "Using default algorithm" << endl;
			(*algorithms.access(""))(k);
		} else {
			cerr << "WARNING: No default algorithm - no clustering will be done!" << endl;
		}
	}
}


